*****************************************************************************
**                      Replication do-file for article                    **
** Continuity Trumps? The impact of interviewer change on item nonresponse **
**                  authors: Kristin Hajek & Nina Schumann                 ** 
*****************************************************************************

************************************
** 5a) Analyses all CAPI question **
************************************

set matsize 11000

use "$Intwechsel\4_sample.dta", clear
cd "$Intwechsel"


********************************
* THREE LEVELS: Decompose each time-varying covariate into three components: cluster-specific means (m* n*) and deviation scores (d*)
* cluster: id & intid
********************************
foreach var of varlist last_nonres wave1 wave2 wave3 wave4 wave5 wave6 wave7 ///
	intage agediff m_intf f_intf intnum_h interv_enc_second? ///
	move_dist move_close ///
	interv_enc_second1_dist interv_enc_second1_close interv_enc_second1_gap {
		bysort id 		: egen  m`var' = mean(`var')     		//between component respondent
		bysort intid 	: egen  n`var' = mean(`var')     		//between component interviewer
		gen              dd`var' = `var' - m`var' - n`var'  	//within component / deviation scores
}


***********************************

// id is held to more precision than MLwiN can handle, //
//it must be recoded so that values lie in the range +/- 16,777,215

replace id=id/1000
bysort id (wave): gen pynr = _n  // person-year
gen  recnr   = _n  // running number record/measurement
gen cons=1



************************************************
************************************************
* Main Models 
************************************************
************************************************


************************
* 1) don't know
************************

* WITHOUT INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model3a

* VPC or ICC statistics
est restore model3a
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_3a = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_3a =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_3a =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	


* INCLUDING INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  

* cross-classified, 3-level 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons, residuals(v)) ///
    level2(intid: cons, residuals(u)) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model3b	

* VPC or ICC statistics
est restore model3b
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_3b = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_3b =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_3b =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



************************
* 2) refusals
************************

* WITHOUT INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model4a

* VPC or ICC statistics
est restore model4a
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_4a = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_4a =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_4a =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	


* INCLUDING INTERVIEWER CHARACTERISTICS

** TWO CLUSTER MEANS
sort id intid pynr 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons, residuals(w)) ///
    level2(intid: cons, residuals(x)) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model4b

* VPC or ICC statistics
est restore model4b
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_4b = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_4b =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_4b =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	


**************
* TABLE 
**************

	esttab model3a model3b model4a model4b using runmlwin_capi.rtf, replace ///
	mtitles("Model 3a" "Model 3b" "Model 4a" "Model 4b") ///
	star(+ 0.10 * 0.05 ** 0.01 *** 0.001) stats(N dic dthetabar dbar pd) label ///
	keep(*cons* dd*)

sum icc*3a icc*3b icc*4a icc*4b



************************************************
************************************************
* Robustness Checks / Additional Models 
************************************************
************************************************


************************************************
************************************************
* 1) Interviewer change and move simultaneously
************************************************
************************************************

************************
* 1) don't know
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_dist minterv_enc_second1_dist ninterv_enc_second1_dist ///
			ddinterv_enc_second1_close minterv_enc_second1_close ninterv_enc_second1_close ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  

* cross-classified, 3-level 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_dist minterv_enc_second1_dist ninterv_enc_second1_dist ///
			ddinterv_enc_second1_close minterv_enc_second1_close ninterv_enc_second1_close ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model1b_m	

* VPC or ICC statistics
est restore model1b_m
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_1b_m = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_1b_m =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_1b_m =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



************************
* 2) refusals
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

** TWO CLUSTER MEANS
sort id intid pynr 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_dist minterv_enc_second1_dist ninterv_enc_second1_dist ///
			ddinterv_enc_second1_close minterv_enc_second1_close ninterv_enc_second1_close ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_dist minterv_enc_second1_dist ninterv_enc_second1_dist ///
			ddinterv_enc_second1_close minterv_enc_second1_close ninterv_enc_second1_close ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model2b_m

* VPC or ICC statistics
est restore model2b_m
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_2b_m = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_2b_m =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_2b_m =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



**************
* TABLE 
**************

	esttab model1b_m model2b_m using runmlwin_capi_move.rtf, replace ///
	mtitles("Model 3b" "Model 4b") ///
	star(+ 0.10 * 0.05 ** 0.01 *** 0.001) stats(N dic dthetabar dbar pd) label ///
	keep(*cons* dd*)

sum icc*1b_m icc*2b_m


		
************************************************
************************************************
* 2) Interviewer change and gap in previous wave
* incl. main effect gap
************************************************
************************************************

************************
* 1) don't know
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_gap minterv_enc_second1_gap ninterv_enc_second1_gap ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h ///
			ddlast_nonres mlast_nonres nlast_nonres, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  

* cross-classified, 3-level 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_gap minterv_enc_second1_gap ninterv_enc_second1_gap ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h ///
			ddlast_nonres mlast_nonres nlast_nonres, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model1b_g_m	

* VPC or ICC statistics
est restore model1b_g_m
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_1b_g_m = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_1b_g_m =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_1b_g_m =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



************************
* 2) refusals
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

** TWO CLUSTER MEANS
sort id intid pynr 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_gap minterv_enc_second1_gap ninterv_enc_second1_gap ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h ///
			ddlast_nonres mlast_nonres nlast_nonres, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddinterv_enc_second1_gap minterv_enc_second1_gap ninterv_enc_second1_gap ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h ///
			ddlast_nonres mlast_nonres nlast_nonres, ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model2b_g_m

* VPC or ICC statistics
est restore model2b_g_m
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_2b_g_m = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_2b_g_m =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_2b_g_m =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



**************
* TABLE 
**************

	esttab model1b_g_m model2b_g_m using runmlwin_capi_gap_m.rtf, replace ///
	mtitles("Model 1b" "Model 2b") ///
	star(+ 0.10 * 0.05 ** 0.01 *** 0.001) stats(N dic dthetabar dbar pd) label ///
	keep(*cons* dd*)

sum icc*1b_g_m icc*2b_g_m



	
************************************************
************************************************
* 3) Differences by cohort
************************************************
************************************************

forvalues x=1/3 {
	
************************
* 1) don't know
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

* 3 levels, not cross-classified, linear --> starting values 
sort id intid pynr 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h  if cohort==`x', ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  

* cross-classified, 3-level 
runmlwin missingsPC_CAPI_1_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h  if cohort==`x', ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model1b_c`x'	

* VPC or ICC statistics
est restore model1b_c`x'
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_1b_c`x' = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_1b_c`x' =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_1b_c`x' =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



************************
* 2) refusals
************************

* INCLUDING INTERVIEWER CHARACTERISTICS

** TWO CLUSTER MEANS
sort id intid pynr 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h  if cohort==`x', ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
	nopause  mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe)  
	
* cross-classified, 3-level 
runmlwin missingsPC_CAPI_2_n cons ddinterv_enc_second? minterv_enc_second? ninterv_enc_second? ///
			ddwave2 ddwave3 ddwave4 ddwave5 ddwave6 ddwave7 mwave2 mwave3 mwave4 mwave5 mwave6 mwave7 ///		
			nwave2 nwave3 nwave4 nwave5 nwave6 nwave7 ///
			ddmove_dist mmove_dist nmove_dist ddmove_close mmove_close nmove_close ///
			ddintage mintage nintage ddagediff magediff nagediff ///
			ddm_intf mm_intf nm_intf ddf_intf mf_intf nf_intf ddintnum_h mintnum_h nintnum_h  if cohort==`x', ///
    level3(id: cons) ///
    level2(intid: cons) ///
    level1(pynr: cons) ///
    mcmc(cc) nopause mlwinpath(C:\Program Files (x86)\MLwiN trial\i386\mlwin.exe) initsprevious 
estimates store model2b_c`x'

* VPC or ICC statistics
est restore model2b_c`x'
display [RP1]var(cons) [RP2]var(cons) [RP3]var(cons)
gen icc_int_2b_c`x' = round([RP2]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // interviewer
gen icc_o_2b_c`x' =	 round([RP1]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // observation / panel part.
gen icc_r_2b_c`x' =	 round([RP3]var(cons)/([RP3]var(cons) + [RP2]var(cons) + [RP1]var(cons)),.001) // respondent	



**************
* TABLE 
**************

	esttab model1b_c`x' model2b_c`x' using runmlwin_capi_c`x'.rtf, replace ///
	mtitles("Model 3b" "Model 4b") ///
	star(+ 0.10 * 0.05 ** 0.01 *** 0.001) stats(N dic dthetabar dbar pd) label ///
	keep(*cons* dd*)
}

sum icc*1b_c? icc*2b_c?

	

**************** SAVE ICCs *****************

keep icc_*
keep if _n==1
save icc_capi.dta, replace








